<?php 

	/*

		File Name	: 	widget-parallax.php

		Date		: 	21 Oct 2022

		

		Theme Name	: 	Judah Vinjai

		Author		: 	Irudayamani

		Author URI	: 	https://www.judahsoftware.in/

		Description	: 	Parallax widgets

	*/

	

	class Judah_Widget_Parallax extends WP_Widget {

		function __construct() {

			parent::__construct(

				'judah_widget_parallax', 

				__('Judah Widget - Parallax', 'judahvinjai'), 

				array( 'description' => __( 'Parallax section in home page', 'judahvinjai' ), ) 

			);

		}

		 

		// Creating widget front-end

		function widget( $args, $instance ) {

			$title 		= 	apply_filters( 'widget_title', $instance['title'] );

			$image_link	= 	$instance['image_link'];

			$linkto 	= 	$instance['linkto'];

			

			if ( !empty ( $image_link ) ):

				echo $args['before_widget'];

				echo '<div class="js-parallax" style="background-image:url(' . $image_link . ');"></div>';

				echo $args['before_title'];

				

				echo $args['before_link'];

				echo $linkto;

				echo $args['after_link'];

				echo $title;

				echo $args['after_link_2'];

				

				echo $args['after_title'];

				

				echo $args['after_widget'];

			endif;

		}

				 

		function form( $instance ) {

			if ( isset ( $instance[ 'title' ] ) ):

				$title = $instance[ 'title' ];

			else: 

				$title = __( '', 'judahvinjai' );

			endif;

			if ( isset ( $instance[ 'image_link' ] ) ):

				$image_link = $instance[ 'image_link' ];

			else: 

				$image_link = __( '', 'judahvinjai' );

			endif;

			if ( isset ( $instance[ 'linkto' ] ) ):

				$linkto = $instance[ 'linkto' ];

			else: 

				$linkto = __( '', 'judahvinjai' );

			endif;

?>

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'judahvinjai' ); ?></label> 

				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" placeholder="Title" value="<?php echo esc_attr( $title ); ?>" />

			</p>

			<p>

				<label><?php _e( 'Background Image Link', 'judahvinjai' ); ?></label>

				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'image_link' )); ?>" type="text" placeholder="Background Image link" value="<?php echo esc_attr( $image_link ); ?>" >

			</p>

			<p>

				<label><?php _e( 'Link to:', 'judahvinjai' ); ?></label>

				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'linkto' )); ?>" type="text" placeholder="Link to page" value="<?php echo esc_attr( $linkto ); ?>" >

			</p>

			

<?php 

		}

			 

		function update( $new_instance, $old_instance ) {

			$instance 				= 	array();

			$instance['title'] 		= 	( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

			$instance['image_link'] = 	( ! empty( $new_instance['image_link'] ) ) ? strip_tags( $new_instance['image_link'] ) : '';

			$instance['linkto'] 	= 	( ! empty( $new_instance['linkto'] ) ) ? strip_tags( $new_instance['linkto'] ) : '';

			return $instance;

		}

	} 

?>

