<?php 
	/*
		File Name	: 	widget-archives.php
		Date		: 	13 Nov 2021
		
		Theme Name	: 	Judah Vathanam
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Display archives widget in back end and contents in front end
	*/
	
	class Judah_Widgets_Archives extends WP_Widget 
	{	function __construct() 
		{	parent::__construct(
				'judah_widget_archives', 											// div container id & class - a prefix "widget_" will be included
				__('Judah Widget - Archives', TEXTDOMAIN), 							// Title displayed in Appearance -> Widgets -> Available Widgets
				array( 'description' => __( 'Display Archives', TEXTDOMAIN ), ) 	// Description displayed in Appearance -> Widgets -> Available Widgets
			);
		}
		 
		// Creating widget front-end
		function widget( $args, $instance ) 
		{	$title = apply_filters( 'widget_title', $instance['title'] );
			
			$count    = ! empty( $instance['count'] ) ? '1' : '0';
			$dropdown = ! empty( $instance['dropdown'] ) ? '1' : '0';
			
			echo $args['before_widget'];
			
			if ( ! empty( $title ) )
				echo $args['before_title'] . $title . $args['after_title'];
			
			if ( $dropdown ) {
				$dropdown_id = "{$this->id_base}-dropdown-{$this->number}";
				?>
			<select class="form-control" id="<?php echo esc_attr( $dropdown_id ); ?>" name="archive-dropdown">
				<?php
				$dropdown_args = apply_filters(
					'widget_archives_dropdown_args',
					array(
						'type'            => 'monthly',
						'format'          => 'option',
						'show_post_count' => $count,
					),
					$instance
				);

				switch ( $dropdown_args['type'] ) {
					case 'yearly':
						$label = __( 'Select Year' );
						break;
					case 'monthly':
						$label = __( 'Select Month' );
						break;
					case 'daily':
						$label = __( 'Select Day' );
						break;
					case 'weekly':
						$label = __( 'Select Week' );
						break;
					default:
						$label = __( 'Select Post' );
						break;
				}

				$type_attr = current_theme_supports( 'html5', 'script' ) ? '' : ' type="text/javascript"';
				?>

				<option value=""><?php echo esc_attr( $label ); ?></option>
				<?php wp_get_archives( $dropdown_args ); ?>

			</select>

	<script<?php echo $type_attr; ?>>
	/* <![CDATA[ */
	(function() {
		var dropdown = document.getElementById( "<?php echo esc_js( $dropdown_id ); ?>" );
		function onSelectChange() {
			if ( dropdown.options[ dropdown.selectedIndex ].value !== '' ) {
				document.location.href = this.options[ this.selectedIndex ].value;
			}
		}
		dropdown.onchange = onSelectChange;
	})();
	/* ]]> */
	</script>
				<?php
			} else {
				$format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

				/** This filter is documented in wp-includes/widgets/class-wp-nav-menu-widget.php */
				$format = apply_filters( 'navigation_widgets_format', $format );

				if ( 'html5' === $format ) {
					// The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
					$title      = trim( strip_tags( $title ) );
					$aria_label = $title ? $title : $default_title;
					echo '<nav role="navigation" aria-label="' . esc_attr( $aria_label ) . '">';
				}
				?>

				<ul>
					<?php
					wp_get_archives(
						apply_filters(
							'widget_archives_args',
							array(
								'type'            => 'monthly',
								'show_post_count' => $count,
							),
							$instance
						)
					);
					?>
				</ul>

				<?php
				if ( 'html5' === $format ) {
					echo '</nav>';
				}
			}
			
			/* $args = array(
				'type'				=> 'monthly',
				'limit'				=> '',
				'format'			=> 'option', 
				'before'			=> '',
				'after'				=> '',
				'show_post_count'	=> true,
				'echo'				=> 1,
				'order'				=> 'DESC',
				'post_type'			=> 'post'
			);
					
			echo '<select name="archive-dropdown" class="form-control" onchange="document.location.href=this.options[this.selectedIndex].value;">';
			echo '<option value="">' . esc_attr( __( 'Select Month' ) ) . '</option>';
			wp_get_archives( $args );
			echo '</select>'; */
			
			echo $args['after_widget'];

		}
				 
		function form( $instance ) 
		{	if(isset($instance[ 'title' ])) 
			{ 	$title = $instance[ 'title' ]; 
				$category = $instance[ 'category' ]; 
			}
			else { $title = __( 'New title', TEXTDOMAIN ); $category = ''; $number = 5; }
			
			$count        	= ! empty( $instance['count'] ) ? '1' : '0';
			$dropdown     	= ! empty( $instance['dropdown'] ) ? '1' : '0';
?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', TEXTDOMAIN ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<input class="checkbox" type="checkbox"<?php checked( $instance['dropdown'] ); ?> id="<?php echo $this->get_field_id( 'dropdown' ); ?>" name="<?php echo $this->get_field_name( 'dropdown' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'dropdown' ); ?>"><?php _e( 'Display as dropdown' ); ?></label>
			<br/>
				<input class="checkbox" type="checkbox"<?php checked( $instance['count'] ); ?> id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" />
				<label for="<?php echo $this->get_field_id( 'count' ); ?>"><?php _e( 'Show post counts' ); ?></label>
			</p>
			
<?php 
		}
			 
		function update( $new_instance, $old_instance ) 
		{	$instance 				= array();
			$instance['title'] 		= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['count']    	= $new_instance['count'] ? 1 : 0;
			$instance['dropdown'] 	= $new_instance['dropdown'] ? 1 : 0;
			return $instance;
		}
	} 
?>