<?php 
	/*
		File Name	: 	widget-main-image.php
		Date		: 	21 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Home page image
	*/
	
	class Judah_Widgets_Main_Image extends WP_Widget  {
		function __construct() {
			parent::__construct(
				'judah_widget_main_image', 
				__('Judah Widget - Main Image', 'judahvinjai'), 
				array( 'description' => __( 'Main image of home page', 'judahvinjai' ), ) 
			);
		}
		 
		// Creating widget front-end
		function widget( $args, $instance ) {
			//$title 			= 	apply_filters( 'widget_title', $instance['title'] );
			$title 			= 	$instance['title'];
			$image_link		= 	$instance['image_link'];
			$linkto 		= 	$instance['linkto'];
			$content_text	=	$instance['contenttext'];
			$button_text	=	$instance['buttontext'];
			
			if ( !empty ( $image_link ) ):
				echo $args['before_widget'];
				
				echo $args['before_image'];
				echo $image_link;
				echo $args['after_image'];
				
				echo $args['before_content'];
				
				echo $args['before_title'];
				echo $title;
				echo $args['after_title'];
				
				echo $args['before_text'];
				echo $content_text;
				echo $args['after_text'];
				
				echo $args['before_link'];
				echo $linkto;
				echo $args['after_link'];
				echo $button_text;
				echo $args['after_link_2'];
				
				echo $args['after_content'];
				
				echo $args['after_widget'];
			endif;
		}
		
		function form( $instance ) {
			if ( isset ( $instance[ 'title' ] ) ):
				$title = $instance[ 'title' ];
			else: 
				$title = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'image_link' ] ) ):
				$image_link = $instance[ 'image_link' ];
			else: 
				$image_link = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'linkto' ] ) ):
				$linkto = $instance[ 'linkto' ];
			else: 
				$linkto = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'buttontext' ] ) ):
				$button_text = $instance[ 'buttontext' ];
			else: 
				$button_text = __( '', 'judahvinjai' );
			endif;
			if ( isset ( $instance[ 'contenttext' ] ) ):
				$content_text = $instance[ 'contenttext' ];
			else: 
				$content_text = __( '', 'judahvinjai' );
			endif;
?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" placeholder="Title" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'contenttext' ); ?>"><?php _e( 'Contents:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'contenttext' )); ?>" type="text" placeholder="Contents" value="<?php echo esc_attr( $content_text ); ?>" />
			</p>
			<p>
				<label><?php _e( 'Background Image Link', 'judahvinjai' ); ?></label>
				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'image_link' )); ?>" type="text" placeholder="Background Image link" value="<?php echo esc_attr( $image_link ); ?>" >
			</p>
			<p>
				<label><?php _e( 'Link to:', 'judahvinjai' ); ?></label>
				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'linkto' )); ?>" type="text" placeholder="Link to page" value="<?php echo esc_attr( $linkto ); ?>" >
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'buttontext' ); ?>"><?php _e( 'Text on Button:', 'judahvinjai' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'buttontext' )); ?>" type="text" placeholder="Link to page" value="<?php echo esc_attr( $button_text ); ?>" >
			</p>
			
<?php 
		}
			 
		function update( $new_instance, $old_instance ) {
			$instance 				= 	array();
			$instance['title'] 		= 	( ! empty( $new_instance['title'] ) ) ? $new_instance['title'] : '';
			$instance['contenttext']= 	( ! empty( $new_instance['contenttext'] ) ) ? $new_instance['contenttext'] : '';
			$instance['image_link'] = 	( ! empty( $new_instance['image_link'] ) ) ? strip_tags( $new_instance['image_link'] ) : '';
			$instance['linkto'] 	= 	( ! empty( $new_instance['linkto'] ) ) ? strip_tags( $new_instance['linkto'] ) : '';
			$instance['buttontext'] = 	( ! empty( $new_instance['buttontext'] ) ) ? strip_tags( $new_instance['buttontext'] ) : '';
			
			return $instance;
		}
	} 
?>
