// Header one
wp.blocks.registerBlockType ( 'judah/header-one', {
	title: 'Judah H1',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h1 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h1",				// Element tag
				null,
				"Judah Header 1"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h1",
			null,
			props.attributes.content
		);
	}
});

// Header two
wp.blocks.registerBlockType ( 'judah/header-two', {
	title: 'Judah H2',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h2 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h2",				// Element tag
				null,
				"Judah Header 2"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h2",
			null,
			props.attributes.content
		);
	}
});

// Header two
wp.blocks.registerBlockType ( 'judah/header-two-intro', {
	title: 'Judah Introduction',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h2 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h2",				// Element tag
				null,
				"Judah Header 2"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h2",
			null,
			props.attributes.content
		);
	}
});

// Header two contact us
wp.blocks.registerBlockType ( 'judah/header-two-contact', {
	title: 'Judah Contact',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h2 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h2",				// Element tag
				null,
				"Judah Header 2 Contact us"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h2",
			null,
			props.attributes.content
		);
	}
});

// Header three
wp.blocks.registerBlockType ( 'judah/header-three', {
	title: 'Judah H3',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h3 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h3",				// Element tag
				null,
				"Judah Header 3"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h3",
			null,
			props.attributes.content
		);
	}
});

// Header four
wp.blocks.registerBlockType ( 'judah/header-four', {
	title: 'Judah H4',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h4 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h4",				// Element tag
				null,
				"Judah Header 4"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h4",
			null,
			props.attributes.content
		);
	}
});

// Header five
wp.blocks.registerBlockType ( 'judah/header-five', {
	title: 'Judah H5',						// Title shows in the block selection box
	icon: 'heading',						// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create h5 element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"h5",				// Element tag
				null,
				"Judah Header 5"	// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"h5",
			null,
			props.attributes.content
		);
	}
});

// Left aligned paragraph
wp.blocks.registerBlockType ( 'judah/para-left', {
	title: 'Judah left aligned para',					// Title shows in the block selection box
	icon: 'editor-paragraph',				// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",				// Element tag
				null,
				"Judah left aligned para"		// Element title
			),
			React.createElement("textarea", { style: { width: "100%", height: "150px" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"p",
			null,
			props.attributes.content
		);
	}
});

// Right aligned paragraph
wp.blocks.registerBlockType ( 'judah/para-right', {
	title: 'Judah right aligned para',					// Title shows in the block selection box
	icon: 'editor-paragraph',				// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",				// Element tag
				null,
				"Judah right aligned para"		// Element title
			),
			React.createElement("textarea", { style: { width: "100%", height: "150px" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"p",
			null,
			props.attributes.content
		);
	}
});

// Centre aligned paragraph
wp.blocks.registerBlockType ( 'judah/para-center', {
	title: 'Judah centre aligned para',					// Title shows in the block selection box
	icon: 'editor-paragraph',				// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",				// Element tag
				null,
				"Judah centre aligned para"		// Element title
			),
			React.createElement("textarea", { style: { width: "100%", height: "150px" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"p",
			null,
			props.attributes.content
		);
	}
});

// Justified paragraph
wp.blocks.registerBlockType ( 'judah/para-justify', {
	title: 'Judah justified para',					// Title shows in the block selection box
	icon: 'editor-paragraph',				// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",				// Element tag
				null,
				"Judah justified para"		// Element title
			),
			React.createElement("textarea", { style: { width: "100%", height: "150px" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"p",
			null,
			props.attributes.content
		);
	}
});

// Introduction paragraph
wp.blocks.registerBlockType ( 'judah/para-intro', {
	title: 'Judah introduction para',		// Title shows in the block selection box
	icon: 'editor-paragraph',				// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	/* This configures how the content and color fields will work, and sets up the necessary elements */

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",				// Element tag
				null,
				"Judah introduction para"		// Element title
			),
			React.createElement("textarea", { style: { width: "100%", height: "150px" }, value: props.attributes.content, onChange: updateContent }),
		);
	},
	save: function(props) {
		return wp.element.createElement(
			"p",
			null,
			props.attributes.content
		);
	}
});

// Ad Banner
wp.blocks.registerBlockType ( 'judah/banner-one', {
	title: 'Judah advt. banner without target link',			// Title shows in the block selection box
	icon: 'format-image',					// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",						// Element tag
				null,
				"Judah advt. banner without target link"		// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, placeholder:"Copy & paste the image url", value: props.attributes.content, onChange: updateContent }),
		);
		
	},
	save: function(props) {
		return wp.element.createElement(
			"img",
			{ className: "img img-fluid", src: props.attributes.content },
			props.attributes.content,
			
		);
	}
});

// Main Image
// Ad Banner
wp.blocks.registerBlockType ( 'judah/main-image', {
	title: 'Judah Main Animated Image',		// Title shows in the block selection box
	icon: 'format-image',					// Icon shows in the block selection box
	category: 'common',						// In which category the block would appear
	attributes: {
		content: {type: 'string'},			// Content type of the element
	},
	

	edit: function(props) {
		// Update content of the element
		function updateContent(event) {
			props.setAttributes({content: event.target.value})
		}
		
		// Create the element with div tag
		// Create p element within the div tag
		// Create text box
		// Create colour picker
		return React.createElement(
			"div",
			null,
			React.createElement(
				"p",						// Element tag
				null,
				"Judah main image"		// Element title
			),
			React.createElement("input", { type: "text", style: { width: "100%" }, placeholder:"Copy & paste the image url", value: props.attributes.content, onChange: updateContent }),
		);
		
	},
	save: function(props) {
		return wp.element.createElement(
			"img",
			{ className: "zoom-in", id:"js-zoom-main", src: props.attributes.content },
			props.attributes.content,
			
		);
	}
});
