<?php 

	/*

		File Name	: 	widget-quick-menu.php

		Date		: 	13 Nov 2021

		

		Theme Name	: 	Judah Vathanam

		Author		: 	Irudayamani

		Author URI	: 	https://www.judahsoftware.in/

		Description	: 	Display quick menu widget in back end and contents in front end

	*/

	

	class Judah_Widgets_Quick_Menu extends WP_Widget 

	{	function __construct() 

		{	parent::__construct(

				'judah_widget_quick_menu', 														// div container id & class - a prefix "widget_" will be included

				__('Judah Widget - Quick Menu', TEXTDOMAIN), 									// Title displayed in Appearance -> Widgets -> Available Widgets

				array( 'description' => __( 'Display categories as quick menu', TEXTDOMAIN ), ) // Description displayed in Appearance -> Widgets -> Available Widgets

			);

		}

		 

		// Creating widget front-end

		function widget( $args, $instance ) 

		{	$title = apply_filters( 'widget_title', $instance['title'] );

			$exclude_category	=	$instance['exclude_category'];

			// before and after widget arguments are defined by themes

			

			$exclude_category_names	= 	explode( ',', $exclude_category );

			$exclude_category_ids	=	array();

			

			foreach ( $exclude_category_names as $cat_name ) {

				$exclude_category_ids[]	=	get_cat_ID( trim ( $cat_name ) );

			}

			

			

			echo str_replace ( 'js-widget-cont', 'js-widget-cont js-widget-cont-background', $args['before_widget'] );

			

			if ( ! empty( $title ) ) {

				echo $args['before_title'];

				echo $title;

				echo $args['after_title'];

			}

			

			echo '<ul class="navbar-nav">';

				wp_list_categories( array(

					'orderby'    	=> 	'name',

					//'show_count'	=> 	true,

					'exclude'		=> 	$exclude_category_ids,

					'title_li'		=> 	'',						// hides title Categories

					'style'			=>	'list'					// displays as list item <li>

				) );

				

			echo '</ul>';

			echo $args['after_widget'];

		}

				 

		function form( $instance ) 

		{	if ( isset ( $instance[ 'title' ] ) ):

				$title = $instance[ 'title' ];

			else: 

				$title = __( '', TEXTDOMAIN );

			endif;

			

			if ( isset ( $instance[ 'exclude_category' ] ) ):

				$exclude_category = $instance[ 'exclude_category' ];

			else: 

				$exclude_category = __( '', TEXTDOMAIN );

			endif;

?>

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', TEXTDOMAIN ); ?></label> 

				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

			</p>

			<p>

				<label for="<?php echo $this->get_field_id( 'exclude_category' ); ?>"><?php _e( 'Exclude Categories:', TEXTDOMAIN ); ?></label> 

				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'exclude_category' )); ?>" type="text" value="<?php echo esc_attr( $exclude_category ); ?>" />

			</p>

			

<?php 

		}

			 

		function update( $new_instance, $old_instance ) 

		{	$instance 						= 	array();

			$instance['title'] 				= 	( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

			$instance['exclude_category'] 	= 	( ! empty( $new_instance['exclude_category'] ) ) ? strip_tags( $new_instance['exclude_category'] ) : '';

			return $instance;

		}

	} 

?>