<?php
	/*
		File Name	: 	sidebar-init.php
		Date		: 	21 Oct 2022
		
		Theme Name	: 	Judah Vinjai
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Setup Widget Areas
	*/
	
	
	function judah_sidebar_init() {
		
		// Parallax section 
		register_sidebar( array (
			'name'			=>	esc_html__( 'Parallax', TEXTDOMAIN ),
			'id'			=>	'sidebar-parallax-1',
			'description'	=>	esc_html__( 'Create a parallax section in home page', TEXTDOMAIN ),
			'before_widget'	=>	'<div class="col ps-0 pe-0 js-pos-rel">',
			'after_widget'	=>	'</div>',
			'before_title'	=>	'<div class="js-parallax-text">',
			'after_title'	=>	'</div>',
			'before_link'	=>	'<a href="',
			'after_link'	=>	'" class="btn btn-success ps-4 pe-4 js-text-2p0 js-md-text-2p5">',
			'after_link_2'	=>	'</a>'
		) );
		
		// Main image
		register_sidebar( array (
			'name'			=>	esc_html__( 'Home Main Image', TEXTDOMAIN ),
			'id'			=>	'sidebar-home-image',
			'description'	=>	esc_html__( 'Main header image in home page', TEXTDOMAIN ),
			'before_widget'	=>	'<div class="col ps-0 pe-0 js-ofh">',
			'after_widget'	=>	'</div>',
			'before_image'	=>	'<div class="row"><div class="col"><img class="img img-fluid zoom-in" id="js-zoom-main" src="',
			'after_image'	=>	'" alt="Main image"></div></div>',
			'before_content'=>	'<div class="row"><div class="col js-mi-d">',
			'after_content'	=>	'</div></div>',
			'before_title'	=>	'<h2 class="animated bounceInDown slowest go js-mi-h">',
			'after_title'	=>	'</h2>',
			'before_text'	=>	'<p class="js-mi-p">',
			'after_text'	=>	'</p>',
			'before_link'	=>	'<div class="mt-md-5"><a class="btn btn-primary js-btn-vm ps-4 pe-4 mt-md-5 mt-4" href="',
			'after_link'	=>	'"">',
			'after_link_2'	=>	'</a></div>',
		) );
		
		// Sidebar - About us icons
		register_sidebar( array (
			'name'					=>	esc_html__( 'Sidebar about us icons', TEXTDOMAIN ),
			'id'					=>	'sidebar-about-us-icons',
			'description'			=>	esc_html__( 'Create a widget area to place about us icons', TEXTDOMAIN ),
			'before_widget'			=>	'<div class="row"><div class="col"><div class="row js-adv-bk"><div class="col mt-2 mt-md-5 pt-2 pt-md-5 pb-5 ps-0 pe-0 js-ofh-x">',
			'after_widget'			=>	'</div></div></div></div>',
			'before_title_cont'		=>	'<div class="row"><div class="col">',
			'after_title_cont'		=>	'</div></div>',
			'before_title'			=>	'<h3 class="js-adv-h3">',
			'after_title'			=>	'</h3>',
			'before_heading'		=>	'<h4 class="js-adv-h4">',
			'after_heading'			=>	'</h4>',
			'before_content_cont'	=>	'<div class="row mt-5"><div class="col"><div class="container"><div class="row">',
			'after_content_cont'	=>	'</div></div></div></div>',
			'before_content_cont2'	=>	'<div class="col-md-4"><div class="row">',
			'after_content_cont2'	=>	'</div></div>',
			'before_image'			=>	'<div class="col-3"><div class="js-icon"><img class="img img-fluid" src="',
			'after_image'			=>	'"></div></div>',
			'before_text'			=>	'<div class="col-9"><p class="js-adv-p">',
			'after_text'			=>	'</p></div>',
		) );
		
		
		// Sidebar in footer 4th column
		register_sidebar( array (
			'name'			=>	esc_html__( 'Sidebar in footer', TEXTDOMAIN ),
			'id'			=>	'sidebar-footer-4',
			'description'	=>	esc_html__( 'Create a sidebar in the footer\'s; 4th column. e.g.) Subscribe for newsletter', TEXTDOMAIN ),
			'before_widget'	=>	'<div class="js-widget-cont"><div class="row"><div class="col">',
			'after_widget'	=>	'</div></div></div>',
			'before_title'	=>	'<div class="js-widget-title-cont"><h5 class="js-bb text-center text-md-start">',
			'after_title'	=>	'</h5></div>',
			'before_content'=>	'<div class="js-widget-content-cont">',
			'after_content'	=>	'</div>',
		) );

		// sidebar about us section
		register_sidebar( array (
			'name'			=>	esc_html__( 'Sidebar in the right side', TEXTDOMAIN ),
			'id'			=>	'sidebar-right',
			'description'	=>	esc_html__( 'Create a side bar in the right side of the page, post.', TEXTDOMAIN ),
			'before_widget'	=>	'<div class="js-widget-cont"><div class="row"><div class="col">',
			'after_widget'	=>	'</div></div></div>',
			'before_title'	=>	'<div class="js-widget-title-cont"><h5 class="js-bb text-center text-md-start">',
			'after_title'	=>	'</h5></div>',
			'before_content'=>	'<div class="js-widget-content-cont">',
			'after_content'	=>	'</div>',
		) );
		
		
		// sidebar quick menu
		register_sidebar( array (
			'name'			=>	esc_html__( 'Quick Menu', TEXTDOMAIN ),
			'id'			=>	'sidebar-quick-menu',
			'description'	=>	esc_html__( 'Add widget to quick menu', TEXTDOMAIN ),
			'before_widget'	=>	'<div class="row"><div class="col mt-4 mb-4"><div class="js-widget-cont">',
			'after_widget'	=>	'</div></div></div>',
			'before_title'	=>	'<div class="js-widget-title-cont"><h4 class="js-widget-title js-bb-3px js-bt pt-4">',
			'after_title'	=>	'</h4></div>',
			'before_content'=>	'<div class="js-widget-content-cont"><p class="js-widget-content">',
			'after_content'	=>	'</p></div>',
			'before_link'	=>	'<a href="',
			'after_link'	=>	'" class="btn btn-success ps-4 pe-4 js-text-1p2 js-md-text-1p5">',
			'after_link_2'	=>	'</a>'
		) );
		
	}
	add_action ( 'widgets_init', 'judah_sidebar_init' );
?>