<?php
	/*
		File Name	: 	theme-options.php
		Date		: 	13 Nov 2021
		
		Theme Name	: 	Judah Vathanam
		Author		: 	Irudayamani
		Author URI	: 	https://www.judahsoftware.in/
		Description	: 	Include theme options, enqueue scripts and media scripts,
						Include an menu item in the Settings Menu
						https://wordpress.stackexchange.com/questions/235406/how-do-i-select-an-image-from-media-library-in-my-plugin 
	*/
	
	if ( ! defined ( 'WPINC' ) ) { die; }
	
	define ( "PLUGIN_PAGES", array(
		THEME_NAME . ' Theme Options',
	));
	
	// Load css stylesheets
	function judahplugin_enqueue_styles( $hook ) {
		//if ( 'toplevel_page_judahplugin' == $hook || 'childlevel_page_judahplugin' == $hook ) {
			
		if ( in_array ( get_admin_page_title (), PLUGIN_PAGES ) ) {
			wp_enqueue_style ( 'judah-bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-animations', get_stylesheet_directory_uri() . '/assets/css/animations.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-font-awesome', 'https://use.fontawesome.com/releases/v5.6.3/css/all.css', array(), '', 'all' );
			wp_enqueue_style ( 'judah-custom', get_stylesheet_directory_uri() . '/admin/assets/css/judah-admin-style.css', array(), time(), 'all' );
			
			/* The following script would be loaded in the footer sections. true is for footer */
			wp_enqueue_script( 'bootstrap-bundle-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/js/bootstrap.bundle.min.js', array(), '', true );
			wp_enqueue_script( 'judah-media', get_stylesheet_directory_uri() . '/admin/assets/js/judah-media.js', array('jquery'), time(), true );
			
			// Enqueue WordPress media scripts
			wp_enqueue_media();
		}
	}
	add_action ( 'admin_enqueue_scripts', 'judahplugin_enqueue_styles' );
	
	// Plugin Settings
	include ( 'inc/judahoptions-settings.php' );
	
	// sub menu item inside other menu items
	function judah_options_submenu_item() {
		// the following pages or menu items are available
		// add_theme_page
		// add_dashboard_page
		// add_posts_page
		// add_media_page
		// add_pages_page
		// add_comments_page
		// add_plugins_page
		// add_users_page
		// add_management_page
		// add_options_page
		
		$id	=	TEXTDOMAIN . '-options';
		
		add_options_page(
			__( THEME_NAME . ' Theme Options', TEXTDOMAIN ),
			__( 'Judah Options', TEXTDOMAIN ),
			'manage_options',
			$id,
			'judah_options_backend_data',
			'dashicons-admin-generic',
			100
		);
	}
	
	add_action ( 'admin_menu', 'judah_options_submenu_item' );
	
	function judah_options_backend_data() {
		if ( ! current_user_can ( 'manage_options' ) ) { return; }
		
		echo '<div class="wrap">';
		include ( 'templates/settings-page.php' );
		echo '</div>';
		
	}
?>