<?php 
	class Judah_Widgets_Main_Slider extends WP_Widget 
	{	function __construct() 
		{	parent::__construct(
				'judah_widget_main_slider', 
				__('Judah Widget - Main Slider', 'judahlemuriya'), 
				array( 'description' => __( 'Main slider of home page', 'judahlemuriya' ), ) 
			);
		}
		 
		// Creating widget front-end
		function widget( $args, $instance ) 
		{	$title = apply_filters( 'widget_title', $instance['title'] );
			// before and after widget arguments are defined by themes
			//echo $args['before_widget'];
			//if ( ! empty( $title ) )
			//echo $args['before_title'] . $title . $args['after_title'];
			$idObj = get_category_by_slug($instance['category']); 
			$id = $idObj->term_id;
			
			$ArgsSlider = array(
				'posts_per_page' => 3,
				'offset' => 0,
				'cat' => $id,
				'orderby' => 'ID',
				'order' => 'DESC',
				'include' => '',
				'exclude' => '',
				'meta_key' => '',
				'meta_value' =>'',
				'post_type' => 'post',
				'post_status' => 'publish',
				'suppress_filters' => true
			);
				
			$AciveClass 		= 	'active';
			$CarouIndcatorHtml 	= 	'';
			$CarouselHtml 		= 	'';
			$i					=	0;
	
			$PrimarySlider = new WP_Query( $ArgsSlider );
			if ( $PrimarySlider->have_posts() ) 
			{	while($PrimarySlider->have_posts())
				{ 	$PrimarySlider->the_post();
					if(has_post_thumbnail()) 
					{  	$CarouselBkGrndImg	=	'style = "background-image:url(';
						$CarouselBkGrndImg	.=	get_the_post_thumbnail_url( $PrimarySlider->post_id, 'large' );
						$CarouselBkGrndImg	.=	');"';

						$CarouIndcatorHtml	.= 	'<li data-target="#demo" data-slide-to="' . $i++ . '" class=" js-carousel-indicators ' . $AciveClass . '"></li>';
						$CarouselHtml		.=	'<div class="carousel-item js-carousel-item ' . $AciveClass . '"' . $CarouselBkGrndImg . '>';
						//$CarouselHtml		.=	 get_the_post_thumbnail( $PrimarySlider->post_id, 'large', array( 'class' => 'js-img-w100 js-carousel-img' ) );
						$CarouselHtml		.=	'<div class="carousel-caption animatedParent">';
						$CarouselHtml		.=	'<h3 class="js-carousel-h3 animated bounceInDown slowest go">' . get_the_title() . '</h3>';
						$CarouselHtml		.=	'<h4 class="js-car_p animated bounceInRight slowest go">' . get_the_content() . '</h4>';
						/*$CarouselHtml		.=	'<h5 class="js-car_p">' . get_the_excerpt() . '</h5>';*/
						/* $CarouselHtml		.=	'<h3 class="js-carousel-h3">';
						$CarouselHtml		.=	'<a class="js-link-col" href="' . get_permalink(get_the_id()) . '">' . get_the_title() . '</a>';
						$CarouselHtml		.=	'</h3>'; */
						$CarouselHtml		.=	'</div>';
						$CarouselHtml		.=	'</div>';
						$AciveClass = '';
					}
					//$AciveClass = '';
				}
				$CarouIndcatorHtml	= '<ul class="carousel-indicators">' . $CarouIndcatorHtml . '</ul>';
?>
				<!--<section class="d-none d-sm-block" id="">-->
				<section class="js-main-slider" id="">
					<div id="demo" class="carousel slide js-carousel" data-ride="carousel">
						<!-- Indicators -->
						<?php echo $CarouIndcatorHtml; ?>

						<!-- The slideshow -->
						<?php echo $CarouselHtml; ?>
						
						<!-- Left and right controls -->
						<a class="carousel-control-prev" href="#demo" data-slide="prev">
							<span class="carousel-control-prev-icon"></span>
						</a>
						<a class="carousel-control-next" href="#demo" data-slide="next">
							<span class="carousel-control-next-icon"></span>
						</a>
					</div>
				</section>
<?php
				
				wp_reset_postdata();
			}
			//echo $args['after_widget'];
		}
		
		function form( $instance ) 
		{	if ( isset ( $instance[ 'title' ] ) ):
				$title = $instance[ 'title' ];
			else: 
				$title = __( '', 'judahlemuriya' );
			endif;
			if ( isset ( $instance[ 'category' ] ) ):
				$category = $instance[ 'category' ];
			else: 
				$category = __( '', 'judahlemuriya' );
			endif;
?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'judahlemuriya' ); ?></label> 
				<input class="widefat" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" placeholder="Title" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label><?php _e( 'Category:', 'judahlemuriya' ); ?></label>
				<input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'category' )); ?>" type="text" placeholder="Category Name" value="<?php echo esc_attr( $category ); ?>" >
			</p>
<?php 
		}
			 
		function update( $new_instance, $old_instance ) 
		{	$instance 				= 	array();
			$instance['title'] 		= 	( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['category'] = 	( ! empty( $new_instance['category'] ) ) ? strip_tags( $new_instance['category'] ) : '';
			return $instance;
		}
		 
	} 
?>
